﻿;Copyright 2010-2019 John T. Haller of PortableApps.com
;Website: http://PortableApps.com/ThunderbirdPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "Google Chrome Portable Incognito Mode"
!define NAME "GoogleChromePortableIncognito"
!define VER "1.0.0.0"
!define WEBSITE "https://portableapps.com/apps/internet/google_chrome_portable"
!define LAUNCHERLANGUAGE "English"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Incognito shortcut for Google Chrome Portable"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks ""
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
XPStyle on
Unicode true
ManifestDPIAware true

; Best Compression
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

;=== Include
;(Standard NSIS)
!include FileFunc.nsh
!insertmacro GetParameters ;Requires NSIS 2.40 or better
!include LogicLib.nsh
!include TextFunc.nsh
!insertmacro GetParent
!insertmacro GetFileName
!include "WordFunc.nsh"

;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Languages
LoadLanguageFile "${NSISDIR}\Contrib\Language files\${LAUNCHERLANGUAGE}.nlf"
!include PortableApps.comLauncherLANG_${LAUNCHERLANGUAGE}.nsh

;=== Variables
Var MISSINGFILEORPATH
Var strPortableAppsPath
Var strCurrentDir

Section "Main"
	${GetParent} $EXEDIR $strPortableAppsPath
	${GetFileName} $EXEDIR $strCurrentDir
	
	${WordReplace} $strCurrentDir "Incognito" "" "+" $strCurrentDir

	${If} ${FileExists} `$strPortableAppsPath\$strCurrentDir\GoogleChromePortable.exe`
		;Check command line paramters
		${GetParameters} $0
		${If} $0 == ""
			Exec `"$strPortableAppsPath\$strCurrentDir\GoogleChromePortable.exe" --incognito`
		${Else}
			Exec `"$strPortableAppsPath\$strCurrentDir\GoogleChromePortable.exe" $0 --incognito`
		${EndIf}
	${Else}
		StrCpy $MISSINGFILEORPATH "$strPortableAppsPath\$strCurrentDir\GoogleChromePortable.exe"
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
	${EndIf}
SectionEnd